#!/usr/bin/python3
#!/usr/local/bin/python3.7




#環境に合わせてpythonのパスを１行目に記載する。/usr/local/bin/python3.4や/usr/bin/python等がある
import userdefine
import cgi
#import cgitb
import sys
import io
import re
import json
import base64
import html
import os
import datetime
import random
import shutil
import pathlib
import urllib.request
import urllib.parse
import json
import zipfile
import glob

sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding="utf-8")

#2021/11 抜粋
#Text-to-Speech の料金は、音声への合成のためにサービスに送信された文字数に基づいて、月単位で請求されます。
#WaveNet 音声の最初の 100 万文字は、毎月無料です。
#標準（WaveNet 以外の）音声では、最初の 400 万文字が毎月無料です。
#Text-to-Speech は無料枠以降 100 万文字ごとに課金されます。
#標準（非 WaveNet）音声	0〜400 万文字	1 文字あたり $0.000004 米ドル（100 万文字あたり $4.00 米ドル）
#WaveNet 音声	0〜100 万文字	1 文字あたり $0.000016 米ドル（100 万文字あたり $16.00 米ドル）



cgidir=os.path.dirname(os.path.abspath(__file__)).replace('\\','/')
documentroot=os.path.abspath(cgidir+"/../../").replace('\\','/')
ttstop=documentroot+"/ttstop"
ttscontents=ttstop+"/ttscontents"
ttsshowtemplate=os.path.abspath(documentroot+"/../ttsshowtemplate")
ttsmonth=os.path.abspath(documentroot+"/../ttsmonth")
#cgitb.enable()
ttsmonthcount=0
ckdic={"ck1":"\n","ck2":".","ck3":",","ck4":"?","ck5":"!","ck6":";","ck7":":","ck8":"'","ck9":'"',"ck10":"(","ck11":")","ck12":"\t","ck13":" ","ck14":"|","ck21":"。","ck22":"、","ck23":"？","ck24":"！","ck25":"「","ck26":"」","ck27":"『","ck28":"』","ck29":"（","ck30":"）","ck31":"‘","ck32":"’","ck33":"“","ck34":"”","ck35":"　"}

def checkpermonth(ttstextlength):
    global ttsmonthcount
    try:
        dt=datetime.datetime.now()
        dts='{0:04}{1:02}'.format(dt.year,dt.month)
        fname=ttsmonth+"/ym"+dts+".txt"
        cnt=ttstextlength
        if os.path.isfile(fname):
            f= open(fname,'r',encoding='UTF-8')
            cntstr=f.read()
            ttsmonthcount=int(cntstr)
            cnt+=ttsmonthcount;
            f.close()
        if cnt>userdefine.limittextpermonth:
            return False
        if os.path.isdir(ttsmonth)==False:
            os.makedirs(ttsmonth)
        if ttstextlength>0:
            f= open(fname,'w',encoding='UTF-8')
            f.write(str(cnt))
            f.close()
        return True
    except:
        return False
        
def removeunodir(uno):
    if os.path.isdir(ttscontents+"/"+uno):
        shutil.rmtree(ttscontents+"/"+uno)
    
def copyttsshow(unottsshow):
    copydirs(ttsshowtemplate, unottsshow)


def urlequest(url):
    req = urllib.request.Request(url)
    req.add_header('Content-Type', 'application/json; charset=utf-8')
    return req
    
def tts(infile,outfile):
    f= open(infile,'r',encoding='UTF-8')
    jdata=f.read()
    f.close()
    url = 'https://texttospeech.googleapis.com/v1/text:synthesize?key='+userdefine.ttskey
    jbyte = jdata.encode('utf-8')
    req=urlequest(url)
    with urllib.request.urlopen(req,jbyte) as res:
        retstr = res.read().decode('utf-8')
        f=open(outfile,'w',encoding='UTF-8')
        f.write(retstr)
        f.close()

def escapejson(text):
    text2=text.replace('\n','\\n')
    text2=text2.replace('\t','\\t')
    text2=text2.replace('"','\\"')
    return text2
    
def escapeinjson(text):
    text2=text.replace('\n','\\n')
    text2=text2.replace('\t','\\t')
    text2=text2.replace('"','\\"')
    if text2.endswith('^'):
        text2=text2[:-1]
    if text2.endswith('|'):
        text2=text2[:-1]
    return text2

def escapeproperty(text):
    text2=text.replace('\n','\\n')
    text2=text2.replace('\t','\\t')
    text2=text2.replace('"','&quot;')
    return text2
    
def jsonmaketextvoice(textfile,ttsno,text,textvoice,voice):
    text2=escapejson(text)
    text3=escapejson(textvoice)
    contents='{"ttsno":"'+'{0:06}'.format(ttsno)+'","text":"'+text2+'","textvoice":"'+text3+'","voice":"'+voice+'"}'
    f=open(textfile,'w',encoding='UTF-8')
    f.write(contents)
    f.close()
    
def jsonmake(lang,voice,infile,text):
    text2=escapeinjson(text)
    contents='{"input":{"text":"'+text2+'"},"voice":{"languageCode": "'+lang+'","name": "'+voice+'"},"audioConfig":{"audioEncoding":"MP3"}}'
    f=open(infile,'w',encoding='UTF-8')
    f.write(contents)
    f.close()

def jsonload(jsonfile):
    jsonobj=None
    with open(jsonfile) as f:
        jsonobj=json.load(f)
    return jsonobj
    
def textmake(textfile,text):
    f=open(textfile,'w',encoding='UTF-8')
    f.write(text)
    f.close()


def removeunodirs():
    if userdefine.removelimithours==0:
        return
    #print("removeunodirs start")
    nowt=datetime.datetime.now()
    dirs=glob.glob('../../ttstop/ttscontents/**/') #dir only
    for dirname in dirs:
        #print(dirname,str(len(dirname))+"<br/>")
        #print(str(len("../../ttstop/ttscontents/")+32))
        if len(dirname)<=len("../../ttstop/ttscontents/")+34 and len(dirname)>=len("../../ttstop/ttscontents/")+31:
            dtstr=dirname[len("../../ttstop/ttscontents/"):]
            try:
                histt=datetime.datetime.strptime(dtstr[:14],'%Y%m%d%H%M%S')
                seconds=(nowt-histt).total_seconds()
                hours=seconds/3600
                #print("removeunodirs "+dirname,dtstr[:14],seconds,hours,"<br/>")
                if hours>userdefine.removelimithours or hours<-24:
                    #print("remove dir ",dirname,"<br/>")
                    shutil.rmtree(dirname)
            except:
                pass
    

def copydirs(src, dst):
    names = os.listdir(src)
    for fname in names:
        srcfname = os.path.join(src,fname)
        dstfname = os.path.join(dst,fname)
        if os.path.isdir(srcfname):
            copydirs(srcfname, dstfname)
        else:
            if os.path.isfile(srcfname):
                shutil.copyfile(srcfname,dstfname)

            
def splitfunc(uno,cks,alltxt):
    ttscontentsuno=ttscontents+"/"+uno
    if not os.path.isdir(ttscontentsuno):
        os.makedirs(ttscontentsuno)
    resource=ttscontentsuno+"/resource"
    if not os.path.isdir(resource):
        os.makedirs(resource)
    unottsshow=ttscontentsuno+"/ttsshow"
    if not os.path.isdir(unottsshow):
        os.makedirs(unottsshow)
        copyttsshow(unottsshow)
       
    print("<div id='linetbl'><table class='splittbl'><tr><td width='3%'><input type='checkbox' id='ckall' onChange='checkall()'/><br/><input type='checkbox' id='revbtn' onClick='checkreverse()'/></td><td width='50%'><input type='button' value='Checked text to MP3 using NewVoice' onClick='makecheckedmp3()' /><input type='button' value='Checked text to MP3 using VoiceName' onClick='makeagainwithvoicename()' /></td><td width='10%'><span id='resultinfo'></span></td><td></td><td width='20%'><input type='button' id='exportbtn' value='Export' onClick='exportall()' disabled/></td></tr>")
    print("<tr><td>No.</td><td>search<input type='text' id='searchtxt'/><input type='button' value='search' onClick='searchtext()'/><span id='searchn'></span><span id='rp1'></span><br/>maximum:"+str(userdefine.limittextlinecount)+"chars per line</td><td></td><td></td><td><a id='ziplink' href='' style='display:block'></a></td></tr>")
    spstrs=[]
    clip=""
    ci=0
    lenalltxt=len(alltxt)
    while ci<lenalltxt:
        c=alltxt[ci]
        cnext=""
        if ci+1<lenalltxt:
            cnext=alltxt[ci+1]
        ckflag=False
        for ck,ckval in ckdic.items():
            if c=='^' or (c==ckval and form.getvalue(ck)!=None and form.getvalue(ck)=="1") :
                ckflag=True
                break
        if ckflag:
        		if c!='(' and c!="（" and c!="「" and c!="『" and c!="‘" and c!="“":
        			clip+=c
        			if (cnext==")"and form.getvalue("ck11")!=None and form.getvalue("ck11")=="1") or (cnext=="」"and form.getvalue("ck26")!=None and form.getvalue("ck26")=="1") or (cnext=="』"and form.getvalue("ck28")!=None and form.getvalue("ck28")=="1") or (cnext=="）"and form.getvalue("ck30")!=None and form.getvalue("ck30")=="1") or (cnext=="’"and form.getvalue("ck32")!=None and form.getvalue("ck32")=="1") or (cnext=="”"and form.getvalue("ck34")!=None and form.getvalue("ck34")=="1"):
        				clip+=cnext
        				ci+=1
        			spstrs.append(clip)
        			clip=""
        		else:
        			spstrs.append(clip)
        			clip=c
        else:
        		clip+=c
        ci+=1
    if len(clip)>0:
        spstrs.append(clip)
    i=1
    for clip in spstrs:
        print("<tr id='trline"+'{0:06}'.format(i)+"'><td>"+str(i)+"<input type='checkbox' name='ckline' id='ckline"+str(i)+"' onClick='trclick("+str(i)+")' onKeyDown='trkeydown("+str(i)+")' onKeyUp='trkeyup("+str(i)+")'/></td>")
        audioname="audio"+'{0:06}'.format(i)+".mp3"
        relttscontentsuno=os.path.relpath(ttscontents+"/"+uno,cgidir).replace('\\','/')
        mp3file=relttscontentsuno+"/resource/"+audioname+'?chnon='+addrndurl()
        print('<td><table class="subtbl"><tr class="subtr"><td class="subtd1"><input type="button" onClick="poptxt('+str(i)+')" value="Text"/></td><td class="subtd2"><input type="text" name="linesrc" class="linesrc" id="linesrc'+str(i)+'" onFocusOut="popend(this)" value="'+escapeproperty(clip)+'" maxlength="'+str(userdefine.limittextlinecount+1)+'"></td></tr><tr class="subtr"><td class="subtd1"><input type="button" onClick="poptxv('+str(i)+')" value="Voice"/></td><td class="subtd2"><input type="text" name="line" class="line" id="line'+str(i)+'" onFocusOut="popend(this)" value="'+escapeproperty(clip)+'" maxlength="'+str(userdefine.limittextlinecount+1)+'" ></td></tr></table></td>')
        print("<td><input class='vce' type='button' id='btn"+str(i)+"' value='NewVoice' onClick='updatetts(2,"+str(i)+",false,true)'><br/><input class='vce' type='button' id='btn"+str(i)+"' value='VoiceName' onClick='updatetts(2,"+str(i)+",true,true)'></td>")
        print("<td><span name='voicenm' id='voicenm"+'{0:06}'.format(i)+"'></span><br/><a href='"+mp3file+"' target='__blank'/>"+audioname+"</a></td><td><audio id='audio"+str(i)+"' name='audioctrl' controls src='' style='display:none'></audio><input type='button' id='audiobtn"+str(i)+"' data-src='"+mp3file+"'value='Audio Player' style='width:100%';height:100%' onClick='swaudio("+str(i)+")'/><input class='inst' type='button' value='Insert' onClick='insertline("+str(i)+",false)'/><input  class='inst' type='button' value='Delete' onClick='insertline("+str(i)+",true)'/></td>")
        i+=1
        print("</tr>")
    print("</table>")
    print("</div>")
    

    
def convertfunc(numall,uno,lang,voice,ttsno,ttstextsrc,ttstext):
    ttscontentsuno=ttscontents+"/"+uno
    if not os.path.isdir(ttscontentsuno):
        os.makedirs(ttscontentsuno)
    resource=ttscontentsuno+"/resource"
    if not os.path.isdir(resource):
        os.makedirs(resource)
    unottsshow=ttscontentsuno+"/ttsshow"
    if not os.path.isdir(unottsshow):
        os.makedirs(unottsshow)
        copyttsshow(unottsshow)
    textmake(resource+"/allinfo.json",'{"num":'+str(numall)+'}')
    #print("<div id='txtlist'>")
    #print("<pre>")
    infile=resource+"/in"+'{0:06}'.format(ttsno)+".json"
    outfile=resource+"/out"+'{0:06}'.format(ttsno)+".json"
    textfile=resource+"/text"+'{0:06}'.format(ttsno)+".json"
    mp3file=resource+"/audio"+'{0:06}'.format(ttsno)+".mp3"
    jsonmake(lang,voice,infile,ttstext)
    jsonmaketextvoice(textfile,ttsno,ttstextsrc,ttstext,voice)
    tts(infile,outfile)
    jsonobj=jsonload(outfile)
    #print(jsonobj['audioContent'])
    #textmake(textfile,jsonobj['audioContent'])
    #os.system('certutil -decode '+textfile+' '+mp3file)
    #os.system('base64 '+textfile+' --decode >'+mp3file)
    b64=base64.b64decode(jsonobj['audioContent'])
    f=open(mp3file,"wb")
    f.write(b64)
    f.close()
    #print("</pre>")
    #print("</div>")

def dtstr():
    dt=datetime.datetime.now()
    ri=random.randint(0,1000000000000)
    dts='{0:04}{1:02}{2:02}{3:02}{4:02}{5:02}{6:06}{7:012}'.format(dt.year,dt.month,dt.day,dt.hour,dt.minute,dt.second,dt.microsecond,ri)
    return dts

def addrndurl():
    return str(random.randint(0,1000000))
    
print("Content-Type: text/html; charset=utf-8\n")

removeunodirs()

form = cgi.FieldStorage()
uno=""
renew=False;
if form!=None and form.getvalue("fmid")=="76":
    uno=os.environ['HTTP_REFERER'].split('ttscontents')[1].split('/')[1];
    end=ttstop+"/ttscontents/"+uno+"/data/loadend"
    f = open(end, 'w')
    f.close()
if form!=None and form.getvalue("fmid")=="77":
    uno=os.environ['HTTP_REFERER'].split('ttscontents')[1].split('/')[1];
    end=ttstop+"/ttscontents/"+uno+"/data/playend"
    f = open(end, 'w')
    f.close()
    

if form!=None and form.getvalue("fmid")=="30":
    savefname =form.getvalue('savefname')
    saveno =form.getvalue('saveno')
    savedata =form.getvalue('savedata')
    uno=os.environ['HTTP_REFERER'].split('ttscontents')[1].split('/')[1];
    savedir=ttstop+"/ttscontents/"+uno+"/data"
    if not os.path.isdir(savedir):
        os.makedirs(savedir)
    savefile = savedir+"/"+savefname+"_"+saveno+".json"
    f=open(savefile,'w',encoding='UTF-8')
    f.write(savedata)
    f.close()
    exit()
    
lefthours=None;

if form==None or form.getvalue("uno")==None or len(form.getvalue("uno"))!=32:
    uno=dtstr()
else:
    uno=form.getvalue("uno")
    uno=uno[0:32]
    if os.path.isdir(ttscontents+"/"+uno)==False:
        uno=dtstr()
        renew=True
    else:
        tdatetime=datetime.datetime.strptime(uno[0:14],'%Y%m%d%H%M%S')
        dt=datetime.datetime.now()-tdatetime
        if userdefine.removelimithours!=0 and dt.total_seconds()>3600*userdefine.removelimithours:
            uno=dtstr()

tdatetime=datetime.datetime.strptime(uno[0:14],'%Y%m%d%H%M%S')
dt=datetime.datetime.now()-tdatetime
lefthours=0
if userdefine.removelimithours!=0:
	lefthours=userdefine.removelimithours-int(dt.total_seconds()/3600)
print("<!DOCTYPE html>")
print("<html>");
print("<head>")
print('<meta charset="utf-8"/>')
print('<title>TTS Subtitle Voice Maker</title>')
print("<style>")
stylestr = '''
div{
    width:100%;
}
.splittbl{
    border-collapse: collapse;
    border:1px solid #000;
    margin:3px;
    background-color:#ffffee;
    width:100%;
}
.tblsrc{
    border-collapse: collapse;
    border:1px solid #000;
    margin:3px;
    width:100%;
}
.subtbl{
    border-collapse: collapse;
    border:0;
    margin:0px;
    width:100%;
}

tr{
    border-collapse: collapse;
    border:1px solid #000;
    width:100%;
}

.subtr{
    border-collapse: collapse;
    border:0;
    width:100%;
}

td{
    border-collapse: collapse;
    border:1px solid #000;
    text-align:center;
}

.subtd1{
    border-collapse: collapse;
    border:0;
    width:10%;
}

.subtd2{
    border-collapse: collapse;
    border:0;
    width:90%;
}

textarea{
    height: 40em;
    width: 80em;
}

.linesrc,.line{
    width:90%;
}

.inst{
 width:40%;
}

.vce{
 width:80%;
}


'''
print(stylestr)
print("</style>")
print("<script>")

print("var removelimithours="+str(userdefine.removelimithours)+";")
#print("var limittextpermonth="+str(userdefine.limittextpermonth)+";")
print("var limittextareacount="+str(userdefine.limittextareacount)+";")
print("var limittextlinecount="+str(userdefine.limittextlinecount)+";")

print('var lang="ja-JP";')
print('var voice="ja-JP-Standard-A";')
print("var cklist={};")
print("var fixedlen=80;");
print('var relttscontentsdef="'+os.path.relpath(ttscontents+"/projectid",cgidir).replace('\\','/')+'";')
print('var relttscontentsuno="'+os.path.relpath(ttscontents+"/"+uno,cgidir).replace('\\','/')+'";')
print('var unostr="'+uno+'";')
if renew:
    print("var renew=true;");
else:
    print("var renew=false;");
if form!=None:
    voice=form.getvalue('voice')
    if voice!=None:
        print('voice="'+voice+'";')
    lang=form.getvalue('lang')
    if lang!=None:
        print('lang="'+lang+'";')
    fixedlen=form.getvalue('fixedlen')
    if fixedlen!=None:
        print('fixedlen='+fixedlen+';')
    for ck,ckvalue in ckdic.items():
        ckv=form.getvalue(ck)
        if ckv!=None and ckv=="1":
            print('cklist["'+ck+'"]=1;')
        if ckv!=None and ckv!="1":
            print('cklist["'+ck+'"]=0;')
            
scriptestr ="""
var cknumcnt=0;
var focusi=0;
function doneconvert(ttsmonthcount,ckeckmonthlength,cmdno,ttsno,numall,voice,usevoicenm){
    //console.log(ttsmonthcount);
    elmt("ttsmonthcount").innerHTML=""+ttsmonthcount+" / ";
    var i;
    var cknum=0;
    var firsti=0;
    for(i=1;i<=numall;i++){
    	if(elmt('ckline'+i).checked){
    		if(firsti==0){
    			firsti=i;
    		}
    		cknum++;
    	}
    }
    if(firsti==ttsno){
    	cknumcnt=1;
    }
    else{
    	cknumcnt++;

    }
    if(cmdno==2){
    	cknum=1;
    	cknumcnt=1;
    }
    elmt("resultinfo").innerHTML=""+cknumcnt+"/"+cknum;
    if(cknumcnt==cknum){
    	cknumcnt=0;
    }
    var voicenm=elmt('voicenm'+('000000'+ttsno).slice(-6));
    voicenm.innerHTML=voice;
    var audio=elmt('audio'+ttsno);
    audio.style.display="none";
    var audiobtn=elmt('audiobtn'+ttsno);
    audiobtn.style.backgroundColor="#ddffdd";
    audiobtn.style.display="block";
    audio.src="";//relttscontentsuno+"/resource/audio"+('000000'+ttsno).slice(-6)+".mp3"+"?chnon="+addrndurl();
    if(ckeckmonthlength==0 && cmdno==3 && ttsno<numall){
        updatetts(cmdno,ttsno+1,usevoicenm,false);
    }
    if(ckeckmonthlength==1){
        elmt('cklength').style.display="block";
    }
    
    exportbtnchange(numall);
}

function escapeproperty(text){
    text2=text.replace(/"/g,'&quot;');
    return text2;
}

function exportbtnchange(numall){
    var doneall=true;
    var i;
    for(i=1;numall>0 && i<=numall;i++){
    	if(elmt('voicenm'+('000000'+i).slice(-6)).innerHTML.length==0){
    		doneall=false;
    		break;
    	}
    }
    if(doneall){
    	elmt('exportbtn').disabled=false;
    }
}

function donezip(){
    //console.log("donezip");
    var ziplink=elmt('ziplink');
    ziplink.disabled=false;
    ziplink.style.display='block';

    var zipname="tts"+unostr+".zip";
    ziplink.href=relttscontentsuno+"/"+zipname;
    ziplink.innerHTML="zip download";
    

}

function showplayerlink(){
    var showlink=elmt('showlink');
    if(showlink && relttscontentsuno.length>0){
	    showlink.disabled=false;
	    showlink.style.display='inline-block';
	    showlink.href=relttscontentsuno+"/ttsshow/index.html";
	    showlink.innerHTML="player index";
    }
}

function showsavebtn(){
    var savebtn=elmt('savebtn');
    if(savebtn && relttscontentsuno.length>0){
	    savebtn.disabled=false;
	    savebtn.style.display='inline-block';
    }
    var projid=elmt('projid');
    if(projid && unostr.length>0){
    	projid.value=unostr;
    }
}


function exportall(){
    //console.log("exportall");
    document.fmexpt.submit();
}


function checkall(){

    var ck=elmt('ckall').checked;
    var numall=document.getElementsByName("line").length;
    var i;
    for(i=1;i<=numall;i++){
        elmt('ckline'+i).checked=ck;
    }
}

function checkreverse(){
	elmt('revbtn').checked=false;
    var numall=document.getElementsByName("line").length;
    var i;
    for(i=1;i<=numall;i++){
        elmt('ckline'+i).checked=!elmt('ckline'+i).checked;
    }
}

var schword="";

function replace1tv(isvoice){
    focusi=0;
    var txt=elmt('searchtxt').value;
    var txt1=elmt('rp1t').value;
    var txt2=elmt('rp1v').value;
    var numall=document.getElementsByName("line").length;
    var i;
    for(i=1;i<=numall;i++){
        var strsrc=""+elmt('linesrc'+i).value;
        if(isvoice==false && strsrc.search(txt)>=0){
                schword=txt1;
                elmt('linesrc'+i).value=strsrc.replace(new RegExp(txt,'g'),txt1);
        }

        var strvoice=""+elmt('line'+i).value;
        if(isvoice==true && strvoice.search(txt)>=0){
                schword=txt2;
                elmt('line'+i).value=strvoice.replace(new RegExp(txt,'g'),txt2);
        }

    }
    if(isvoice==false){
        var strsrc=""+elmt('txtcon').value;
        elmt('txtcon').value=strsrc.replace(new RegExp(txt,'g'),txt1);
    }
}

function funcrp1t(){
    replace1tv(false);
}

function funcrp1v(){
    replace1tv(true);
}

function searchtext(){
//console.log("search "+elmt('searchtxt').value);
    focusi=0;
    var txt=elmt('searchtxt').value;
    schword=txt;
    var searchn=elmt('searchn');
    var numall=document.getElementsByName("line").length;
    var col1='#ffffcc';
    var col2='#ffff66';
    if(txt.length==0){
        col1="";
        col2="";
        elmt('rp1').style.display="none";
    }
    var i;
    var hit1=0;
    var hit2=0;
    for(i=1;i<=numall;i++){
        var strsrc=""+elmt('linesrc'+i).value;
        if(strsrc.search(txt)>=0){
            elmt('linesrc'+i).style.backgroundColor=col1;
            hit1++;
        }
        else{
            elmt('linesrc'+i).style.backgroundColor="";
        }
        var strvoice=""+elmt('line'+i).value;
        if(strvoice.search(txt)>=0){
            elmt('line'+i).style.backgroundColor=col2;
            hit2++;
        }
        else{
            elmt('line'+i).style.backgroundColor="";
        }
    }
    if(txt.length==0){
        searchn.innerHTML="";
        elmt('rp1').style.display="none";
    }
    else{
        searchn.innerHTML=" text:"+hit1+" voice:"+hit2+"<br/>jump=Shift+(UP or DOWN)<br/>check on/off=Shift+(LEFT or RIGHT)<br/>";
        elmt('rp1').innerHTML="text<input id='rp1t' value='"+txt+"'/><input type='button' onclick='funcrp1t()' value='replace all'/><br/>voice<input id='rp1v' value='"+txt+"'/><input type='button' onclick='funcrp1v()' value='replace all'/><br/>";
        elmt('rp1').style.display="block";
    }
}

function makecheckedmp3(){
    updatetts(4,1,false,false);
}

function makeagainwithvoicename(){
    updatetts(4,1,true,false);
}

function updatetts(cmdno,i,usevoicenm,issingle){
    if(usevoicenm==false){
      setvoiceselect();
    }
    var numall=document.getElementsByName("line").length;
    if(issingle==false){
        for(;i<=numall;i++){
            if(elmt('ckline'+i).checked==true){
                break;
            }
        }
    }
    if(i>numall){
        return;
    }
    elmt('numall').value=""+numall;
    elmt('fmid').value=""+cmdno;
    var ttsno=elmt('ttsno');
    var ttstextsrc=elmt('ttstextsrc');
    var ttstext=elmt('ttstext');
    ttsno.value=""+i;
    //console.log('line'+i);
    //console.log(elmt('line'+i).value);
    ttstext.value=elmt('line'+i).value;
    if(ttstext.value.length==0){
        ttstext.value=" ";
    }
    ttstextsrc.value=elmt('linesrc'+i).value;
    if(ttstextsrc.value.length==0){
        ttstextsrc.value=" ";
    }
    if(usevoicenm){
        var voicenm=elmt('voicenm'+('000000'+i).slice(-6));
        elmt('voice').value=voicenm.innerHTML;
        if(elmt('voice').value==""){
        	setvoiceselect();
        }
    }
    document.fmtts.usevoicenm.value=usevoicenm;
    if(cmdno==2){
        elmt("audiobtn"+i).style.backgroundColor="#ff5555";
        document.fmtts.submit();
    }
    else{
        if(elmt('ckline'+i).checked){
            elmt("audiobtn"+i).style.backgroundColor="#ff5555";
            document.fmtts.submit();
        }
        else{
            if(i+1<=numall){
                updatetts(cmdno,i+1,usevoicenm,false);
            }
        }
     }
}

function setchecklist(){
    for(var key in cklist){
        if(elmt(key)){
            var value=cklist[key];
            if(value==1){
                elmt(key).checked=true;
            }
            else{
            elmt(key).checked=false;
            }
        }
    }
}
function setlang(){
    if(elmt('lang')){
        elmt('lang').value=lang;
        if(lang){
            if(lang=="en-US"){
                elmt('voiceen').value=voice;
            }
            if(lang=="ja-JP"){
                elmt('voicejp').value=voice;
            }
         }
    }
}

function setvoiceselect(){
    var lang=elmt('lang');
    var voice=elmt('voice');
    if(lang){
        if(lang.value=="en-US"){
            if(elmt('voicejp')){
                elmt('voicejp').style.display="none";
            }
            if(elmt('voiceen')){
                elmt('voiceen').style.display="block";
            }
            if(voice){
                voice.value=elmt('voiceen').value;
            }
        }
        if(lang.value=="ja-JP"){
            if(elmt('voicejp')){
                elmt('voicejp').style.display="block";
            }
            if(elmt('voiceen')){
                elmt('voiceen').style.display="none";
            }
            if(voice){
                voice.value=elmt('voicejp').value;
            }
        }
     }
}

function splittext(){
    elmt('fmid').value="1";
    setvoiceselect();
    document.fmtts.target="";
    //console.log(elmt('txtcon').value.length);
    splitlength(limittextlinecount);
    if(elmt('txtcon').value.length>limittextareacount){
        elmt('txtcon').value=elmt('txtcon').value.substring(0,limittextareacount);
    }
    
    document.fmtts.submit();
}

function cleartextarea(){
    elmt('txtcon').value="";
}

function splitlength(fixedlen){
    var ckdic={"ck1":"\\n","ck2":".","ck3":",","ck4":"?","ck5":"!","ck6":";","ck7":":","ck8":"'","ck9":'"',"ck10":"(","ck11":")","ck12":"\\t","ck13":" ","ck14":"|","ck21":"。","ck22":"、","ck23":"？","ck24":"！","ck25":"「","ck26":"」","ck27":"『","ck28":"』","ck29":"（","ck30":"）","ck31":"‘","ck32":"’","ck33":"“","ck34":"”","ck35":"　"};
    var textsrc=elmt('txtcon').value;
    var text=textsrc.replace(/\\^/g,"");
    //console.log(text);
    var dst=""
    var clip="";
    var i;
    var n=0;
    for(i=0;i<text.length;i++){
        var c=text[i];
        var cnext="";
        if(i+1<text.length){
            cnext=text[i+1];
        }
        var j;
        var ckflag=false;
        for(var key in ckdic){
            if(c==ckdic[key] && elmt(key).checked){
                ckflag=true;
                break;
            }
        }
        if(ckflag){
                if(c!='(' && c!="（" && c!="「" && c!="『" && c!="‘" && c!="“"){
                			clip+=c;
                            if((cnext==")"  && elmt("ck11").checked) 
                            || (cnext=="」" && elmt("ck26").checked) 
                            || (cnext=="』" && elmt("ck28").checked) 
                            || (cnext=="）" && elmt("ck30").checked) 
                            || (cnext=="’" && elmt("ck32").checked) 
                            || (cnext=="”" && elmt("ck34").checked)){
                                clip+=cnext;
                                i++;
                            }
               				dst+=clip;
               				clip="";
                            n=0;
                }
                else{
                			dst+=clip;
                			clip=c;
                            n=1;
                }
         }
         else{
              clip+=c;
              n++;
              if(n>=fixedlen){
                dst+=clip+"^";
                clip="";
                n=0;
              }
         }
    }
    if(clip.length>0){
        dst+=clip;
    }
    elmt('txtcon').value=dst;
}

function splitchars(){
    fixedlen=0+elmt('fixedlen').value;
    splitlength(fixedlen);
}

function setfixedlen(){
    if(elmt('fixedlen')){
        elmt('fixedlen').value=0+fixedlen;
    }
}


function elmt(id){ return document.getElementById(id);}

function Init(){
    setchecklist();
    setlang();
    setfixedlen();
    setvoiceselect();
    showplayerlink();
    showsavebtn();
}
function renewuserdir(){
    if(elmt('renew')){
        elmt('renew').style.display="block";
    }
}

function newproject(){
    location.href="tts.py";
}

if(renew){
    if(parent && parent.renewuserdir){
        parent.renewuserdir();
    }
    else{
        renewuserdir();
    }
}

function savedata(){
//console.log("savedata");
	var cklines=document.getElementsByName("ckline");
	var linesrcs=document.getElementsByName("linesrc");
    var lines=document.getElementsByName("line");
    var voicenms=document.getElementsByName("voicenm");
    var num=cklines.length;
    var i;
    var lineobjary=[];
    for(i=0;i<num;i++){
    	lineobjary.push({"ckline":cklines[i].checked,"line":lines[i].value,"linesrc":linesrcs[i].value,"voicenm":voicenms[i].innerHTML});
    }
	var savedata={"lang":lang,"voicejp":voicejp.value,"voiceen":voiceen.value,"cklist":cklist,"fixedlen":fixedlen
	,"lineobjary":lineobjary
	,"txtcon":elmt('txtcon').value};
	document.datasavefm.savedata.value=JSON.stringify(savedata);
//console.log(document.datasavefm.uno.value);
//console.log(savedata);
	document.datasavefm.submit();
}

function loadjsonfile(callback,jsonpath) {   

  var req = new XMLHttpRequest();
  req.overrideMimeType("application/json;charset=utf-8");
  req.open('GET', jsonpath, true);
  req.onreadystatechange = function(){
	if (req.readyState==4) {
		callback(req);
	}
  };
  req.send(null);  
}

function addrndurl(){
    return Math.floor(Math.random()*1000000)
}

var multiline=false;
var multiid=-1;

function trclick(id){
    if(multiline && multiid>=1){
        var i1=multiid;
        var i2=id;
        if(i1>i2){
            i1=id;
            i2=multiid;
        }
        //console.log(i1,i2);
        var i;
        var ck=elmt("ckline"+i1).checked;
        for(i=i1+1;i<=i2;i++){
            elmt("ckline"+i).checked=ck;
        }
       
    }
    if(multiline==false){
        multiid=id;
    }
}



function trkeydown(id){
    if(event.keyCode==16){//shift
        multiline=true;
    }
    else{
        multiline=false;
    }
}


function trkeyup(id){
    if(event.keyCode==16){//shift
        multiline=false;
        multiid=-1;
    }
}

var value;
function loaddata(){
    //console.log("loaddata");
    var savejsnfile=relttscontentsdef.replace("projectid",unostr)+"/data/save.json";
	//console.log(savejsnfile);
	var dataobj = new Promise(function(resolve, reject) {
			loadjsonfile(function(req) {
				if(req.status=="200"){
			  		var jsn = JSON.parse(req.responseText);
						resolve(jsn);
				 }
				 else{
				  		resolve(null);
				 }

	  		},savejsnfile);

	});

	dataobj.then(function(v) {
			if(v==null){
				;
			}
			else{
                value=v;
                Promise.resolve().then(function() {
                    setTimeout(profunc,100);
    			});
            }
	});

}

function profunc(){
    				//console.log(value.cklist);
    				elmt('lang').value=value.lang;
    				elmt('voicejp').value=value.voicejp;
    				elmt('voiceen').value=value.voiceen;
    				elmt('fixedlen').value=value.fixedlen;
    				
    				setlang();
    				var i;
    				for(i=0;i<100;i++){
    					if(elmt("ck"+i)){
    						elmt("ck"+i).checked=false;
    					}
    				}
    				for(var key in value.cklist){
    					elmt(key).checked=true;
    				}
    				var numall=value.lineobjary.length;
    				var linestr="";
    				linestr+="<table class='splittbl'><tr><td width='3%'><input type='checkbox' id='ckall' onChange='checkall()'/><input type='checkbox' id='revbtn' onClick='checkreverse()'/></td><td width='50%'><input class='vce' type='button' value='Checked text to MP3 using NewVoice' onClick='makecheckedmp3()' /><input class='vce' type='button' value='Checked text to MP3 using VoiceName' onClick='makeagainwithvoicename()' /></td><td width='10%'><span id='resultinfo'></span></td><td></td><td width='20%'><input type='button' id='exportbtn' value='Export' onClick='exportall()' disabled/></td></tr>";
    				linestr+="<tr><td>No.</td><td>search<input type='text' id='searchtxt'/><input type='button' value='search' onClick='searchtext()'/><span id='searchn'></span><span id='rp1'></span><br/>maximum:"+limittextlinecount+"chars per line</td><td></td><td></td><td><a id='ziplink' href='' style='display:block'></a></td></tr>";
    				for(i=1;i<=numall;i++){
    				//console.log(value.lineobjary[i-1]);
                        var istr=('000000' + i ).slice( -6 );
    					linestr+="<tr id='trline"+istr+"'><td>"+i+"<input type='checkbox' name='ckline' id='ckline"+i+"' onClick='trclick("+i+")' onKeyDown='trkeydown("+i+")'  onKeyUp='trkeyup("+i+")'/></td>";
    				    
    				    var audioname="audio"+istr+".mp3";
            			var mp3file=relttscontentsuno+"/resource/"+audioname+"?chnon="+addrndurl();
    				    linestr+='<td><table class="subtbl"><tr class="subtr"><td class="subtd1"><input type="button" onClick="poptxt('+i+')" value="Text"/></td><td class="subtd2"><input type="text" name="linesrc" class="linesrc" id="linesrc'+i+'" onFocusOut="popend(this)" value="'+escapeproperty(value.lineobjary[i-1].linesrc)+'" maxlength="'+(limittextlinecount+1)+'"></td></tr><tr class="subtr"><td class="subtd1"><input type="button" onClick="poptxv('+i+')" value="Voice"/></td><td class="subtd2"><input type="text" name="line" class="line" id="line'+i+'"  onFocusOut="popend(this)" value="'+escapeproperty(value.lineobjary[i-1].line)+'" maxlength="'+(limittextlinecount+1)+'" ></td></tr></table></td>';
    				    linestr+="<td><input class='vce' type='button' id='btn"+i+"' value='NewVoice' onClick='updatetts(2,"+i+",false,true)'><br/><input class='vce' type='button' id='btn"+i+"' value='VoiceName' onClick='updatetts(2,"+i+",true,true)'></td>";
    					linestr+="<td><span name='voicenm' id='voicenm"+istr+"'>"+value.lineobjary[i-1].voicenm+"</span><br/><a href='"+mp3file+"' target='__blank'/>"+audioname+"</a></td><td><audio id='audio"+i+"' name='audioctrl' controls src='' style='display:none'></audio><input type='button' id='audiobtn"+i+"' data-src='"+mp3file+"'value='Audio Player' style='width:100%';height:100%' onClick='swaudio("+i+")'/><input class='inst' type='button' value='Insert' onClick='insertline("+i+",false)'/><input class='inst' type='button' value='Delete' onClick='insertline("+i+",true)'/></td>";
    					linestr+="</tr>";
    				}
    				linestr+="</table>";
    				//console.log(linestr);
    				if(elmt("linetbl")){
    				    elmt("linetbl").innerHTML=linestr;
                    }
                    else{
                        elmt("lineroot").innerHTML="<div id='linetbl'>"+linestr+"</div>";
                    }
    				elmt("txtcon").value=value.txtcon;
    				exportbtnchange(numall);

}

function appendline(lineobjary,j){
    var i;
    var linestr="";
	for(i=j;i-j<lineobjary.length;i++){
        var obj=lineobjary[i-j];
				//console.log(value.lineobjary[i-1]);
                    var istr=('000000' + i ).slice( -6 );
					linestr+="<tr id='trline"+istr+"'><td>"+i+"<input type='checkbox' name='ckline' id='ckline"+i+"' onClick='trclick("+i+")' onKeyDown='trkeydown("+i+")'  onKeyUp='trkeyup("+i+")'/></td>";
				    
				    var audioname="audio"+istr+".mp3";
        			var mp3file=relttscontentsuno+"/resource/"+audioname+"?chnon="+addrndurl();
				    linestr+='<td><table class="subtbl"><tr class="subtr"><td class="subtd1"><input type="button" onClick="poptxt('+i+')" value="Text"/></td><td class="subtd2"><input type="text" name="linesrc" class="linesrc" id="linesrc'+i+'" onFocusOut="popend(this)" value="'+escapeproperty(obj.linesrc)+'" maxlength="'+(limittextlinecount+1)+'"></td></tr><tr class="subtr"><td class="subtd1"><input type="button" onClick="poptxv('+i+')" value="Voice"/></td><td class="subtd2"><input type="text" name="line" class="line" id="line'+i+'"  onFocusOut="popend(this)" value="'+escapeproperty(obj.line)+'" maxlength="'+(limittextlinecount+1)+'" ></td></tr></table></td>';
				    linestr+="<td><input class='vce' type='button' id='btn"+i+"' value='NewVoice' onClick='updatetts(2,"+i+",false,true)'><br/><input class='vce' type='button' id='btn"+i+"' value='VoiceName' onClick='updatetts(2,"+i+",true,true)'></td>";
					linestr+="<td><span name='voicenm' id='voicenm"+istr+"'>"+obj.voicenm+"</span><br/><a href='"+mp3file+"' target='__blank'/>"+audioname+"</a></td><td><audio id='audio"+i+"' name='audioctrl' controls src='' style='display:none'></audio><input type='button' id='audiobtn"+i+"' data-src='"+mp3file+"'value='Audio Player' style='width:100%';height:100%' onClick='swaudio("+i+")'/><input class='inst' type='button' value='Insert' onClick='insertline("+i+",false)'/><input class='inst' type='button' value='Delete' onClick='insertline("+i+",true)'/></td>";
					linestr+="</tr>";
	}
    return linestr;
}


function insertline(j,deleteflag){
    
    var numall=document.getElementsByName("line").length;
    
    var lineobjary=[];
	var cklines=document.getElementsByName("ckline");
	var linesrcs=document.getElementsByName("linesrc");
    var lines=document.getElementsByName("line");
    var voicenms=document.getElementsByName("voicenm");
    if(deleteflag==false){
        lineobjary.push({"ckline":false,"line":"","linesrc":"","voicenm":voicenms[j-1].innerHTML});
        for(i=j-1;i<numall;i++){
        	lineobjary.push({"ckline":cklines[i].checked,"line":lines[i].value,"linesrc":linesrcs[i].value,"voicenm":voicenms[i].innerHTML});
        }
    }
    else{
        for(i=j;i<numall;i++){
        	lineobjary.push({"ckline":cklines[i].checked,"line":lines[i].value,"linesrc":linesrcs[i].value,"voicenm":voicenms[i].innerHTML});
        }
    }
    var i=j;
    var parent=elmt('trline'+('000000' + j ).slice( -6 )).parentNode;
    for(;i<=numall;i++){
       var istr1=('000000' + i ).slice( -6 );
       var elm=elmt('trline'+istr1);
       parent.removeChild(elm);
    }
    var linestr=appendline(lineobjary,j);
    parent.insertAdjacentHTML('beforeend',linestr);
}


function swaudio(i){
//console.log(elmt("audiobtn"+i).dataset.src);
	elmt("audiobtn"+i).style.display="none";
	elmt("audio"+i).style.display="block";
	elmt("audio"+i).src=elmt("audiobtn"+i).dataset.src;
}

function jump(){
    document.jmpfm.uno.value=elmt('projid').value;
    document.jmpfm.submit();
}

function poptxt(i){
	if(parseInt(elmt("linesrc"+i).style.zIndex)!=2){
		elmt("linesrc"+i).style="z-index:2;left:10px;position:absolute;width:"+parseInt(""+parseInt(document.body.clientWidth)*0.95)+"px";
	}
	else{
		popend(elmt("linesrc"+i));
	}
}

function poptxv(i){
	if(parseInt(elmt("line"+i).style.zIndex)!=2){
		elmt("line"+i).style="z-index:2;left:10px;position:absolute;width:"+parseInt(""+parseInt(document.body.clientWidth)*0.95)+"px";
	}
	else{
		popend(elmt("line"+i));
	}
}

function popend(e){
	e.style="";
}

function updatelefthours(){
	var hours=parseInt(elmt("lefthours").innerHTML)-1;
	if(hours>=0){
		elmt("lefthours").innerHTML=""+hours;
	}
	if(hours>0){
		setTimeout(updatelefthours,3600*1000);
	}
}

function scrollelem(elem){
    var rect=elem.getBoundingClientRect();
    var elemtop=rect.top+window.pageYOffset-20;
    document.documentElement.scrollTop=elemtop;
}

function bodykeydown(){
    //if(elmt('searchtxt')==null){
    if(schword==""){
        return;
    }
    var i;
    
    var txt=schword;//var txt=elmt('searchtxt').value;
    var searchn=elmt('searchn');
    var numall=document.getElementsByName("line").length;
    if(txt.length==0){
        return;
    }
    if(event.shiftKey && event.keyCode==38){//shift+arrow up
        var linesrcs=document.getElementsByName("linesrc");
        var lines=document.getElementsByName("line");
        var num=lines.length;
        var findflag=0;
        for(i=focusi-1;i>=0;i--){
            var strsrc=""+linesrcs[i].value;
            var strvoice=""+lines[i].value;
            if(strsrc.search(txt)>=0 || strvoice.search(txt)>=0){
                findflag=1;
                focusi=i;
                scrollelem(linesrcs[i]);
                break;
            }
        }
        if(findflag==0){
            for(i=num-1;i>focusi;i--){
                var strsrc=""+linesrcs[i].value;
                var strvoice=""+lines[i].value;
                if(strsrc.search(txt)>=0 || strvoice.search(txt)>=0){
                    focusi=i;
                    scrollelem(linesrcs[i]);
                    break;
                }
            }
        }
    }
    
    if(event.shiftKey && event.keyCode==40){//shift+arrow down
        var linesrcs=document.getElementsByName("linesrc");
        var lines=document.getElementsByName("line");
        var num=lines.length;
        var findflag=0;
        for(i=focusi+1;i<num;i++){
            var strsrc=""+linesrcs[i].value;
            var strvoice=""+lines[i].value;
            if(strsrc.search(txt)>=0 || strvoice.search(txt)>=0){
                findflag=1;
                focusi=i;
                scrollelem(linesrcs[i]);
                break;
            }
        }
        if(findflag==0){
            for(i=0;i<focusi;i++){
                var strsrc=""+linesrcs[i].value;
                var strvoice=""+lines[i].value;
                if(strsrc.search(txt)>=0 || strvoice.search(txt)>=0){
                    focusi=i;
                    scrollelem(linesrcs[i]);
                    break;
                }
            }
        }
    }

    if(event.shiftKey && event.keyCode==37){//shift+arrow left
        var linesrcs=document.getElementsByName("linesrc");
        var lines=document.getElementsByName("line");
        var num=lines.length;
        for(i=0;i<num;i++){
            var strsrc=""+linesrcs[i].value;
            var strvoice=""+lines[i].value;
            if(strsrc.search(txt)>=0 || strvoice.search(txt)>=0){
                elmt('ckline'+(i+1)).checked=true;
            }
        }
    }
    if(event.shiftKey && event.keyCode==39){//shift+arrow right
        var linesrcs=document.getElementsByName("linesrc");
        var lines=document.getElementsByName("line");
        var num=lines.length;
        for(i=0;i<num;i++){
            var strsrc=""+linesrcs[i].value;
            var strvoice=""+lines[i].value;
            if(strsrc.search(txt)>=0 || strvoice.search(txt)>=0){
                elmt('ckline'+(i+1)).checked=false;
            }
        }
    }

}

"""
print(scriptestr)
print("</script>")
print("</head>")
print("<body onLoad='Init()' onKeyDown='bodykeydown()'>")
print("<form name='datasavefm' action='tts.py' method='POST' target='ifrm1'><input type='hidden' name='savefname' value='save.json'/><input type='hidden' name='fmid' value='20'/><input type='hidden' name='uno' value='"+str(uno)+"'/><input type='hidden' name='savedata' value=''/></form>")
print("TTS Subtitle Voice Maker&nbsp;&nbsp;&nbsp;&nbsp;<a href='https://cooyou.org/ttstop/help/index.html' target='_blank' rel='noopener'>HELP</a>&nbsp;&nbsp;&nbsp;&nbsp;")
print("The number of characters this month : <span id='ttsmonthcount'>")
checkpermonth(0);
if ttsmonthcount>0:
	print(str(ttsmonthcount)+" / ")
print("</span> (limit)"+str(userdefine.limittextpermonth)+"<br/>")
print("<input type='button' value='New' onClick='newproject()'/>&nbsp;&nbsp;project id <input type='text' id='projid' value='' size='40'/> <input type='button' id='loadbtn' value='Load' onClick='jump()'/>&nbsp;&nbsp;&nbsp;&nbsp;<input type='button' id='savebtn' value='Save' onClick='savedata()' style='display:none'/>")
print("&nbsp;&nbsp;&nbsp;&nbsp;<a id='showlink' href='' target='_blank' rel='noopener' style='display:block'></a><br/>")
print("<div id='cklength' style='background-color:red;color:white;display:none'>Sorry. The number of characters is over limit this month.</div>")
print("<div id='renew' style='background-color:red;color:white;display:none'>User resource was time over. It is created newly.</div>")
print("<div id='lineroot'></div>")
name=""
txtcon=""
cks=[]
if form!=None and form.getvalue("fmid")=="50":#jump
    print("<script>loaddata();</script>")
    
if form!=None and form.getvalue("fmid")=="20":
    savefname =form.getvalue('savefname')
    savedata =form.getvalue('savedata')
    ttscontentsuno=ttscontents+"/"+uno
    savedir =ttscontentsuno+"/data"
    if not os.path.isdir(savedir):
        os.makedirs(savedir)
    savefile = savedir+"/"+savefname
    f=open(savefile,'w',encoding='UTF-8')
    f.write(savedata)
    f.close()
    
if form!=None and form.getvalue("fmid")=="1":#split
    txtcon =form.getvalue('txtcon')
    if txtcon==None:
        txtcon=""
    txtcon=txtcon.replace('\r','')
    txtcon=txtcon[0:userdefine.limittextareacount]
    cklist=["ck1","ck2","ck3","ck4","ck5","ck6","ck7","ck8","ck9","ck10","ck11","ck12","ck13","ck14","ck21","ck22","ck23","ck24","ck25","ck26","ck27","ck28","ck29","ck30","ck31","ck32","ck33","ck34","ck35"]
    for ck in cklist:
        cks.append(form.getvalue(ck)=="1")
 
    if len(txtcon)>0:
        splitfunc(uno,cks,txtcon)


if form!=None and (form.getvalue("fmid")=="2" or form.getvalue("fmid")=="3" or form.getvalue("fmid")=="4"):#convert
    cmdno=int(form.getvalue("fmid"));
    lang=form.getvalue('lang')
    voice=form.getvalue('voice')
    ttsnostr=form.getvalue('ttsno')
    ttstextsrc=form.getvalue('ttstextsrc')
    ttstext=form.getvalue('ttstext')
    numall=form.getvalue('numall')
    usevoicenm=form.getvalue('usevoicenm')
    ttsnostr=ttsnostr[0:32]
    ttsno=int(ttsnostr)
    lang=lang[0:256]
    voice=voice[0:256]
    ttstextsrc=ttstextsrc[0:userdefine.limittextlinecount+1]
    ttstext=ttstext[0:userdefine.limittextlinecount+1]
    ttslength=len(ttstext)
    ttslengthflag=0
    if cmdno==4:
        cmdno=3;
        #removeunodir(uno)
    if ttslength>0:
        if checkpermonth(ttslength):
            convertfunc(numall,uno,lang,voice,ttsno,ttstextsrc,ttstext)
        else:
            ttslengthflag=1
    print('<script>parent.doneconvert('+str(ttsmonthcount+ttslength)+","+str(ttslengthflag)+','+str(cmdno)+','+str(ttsno)+','+str(numall)+',"'+voice+'",'+str(usevoicenm)+');</script>')
    exit()


if form!=None and form.getvalue("fmid")=="5":
	ttscontentsuno=ttscontents+"/"+uno
	zp = zipfile.ZipFile(ttscontentsuno+"/tts"+uno+".zip", 'w')
	for dirname, subdirs, filenames in os.walk(ttscontentsuno+"/resource"):
		for fname in filenames:
			ex = os.path.splitext(fname)
			if ex[0]=="allinfo" or ex[1]==".mp3" or ex[0][0:2]=="in":
				zp.write(os.path.join(ttscontentsuno+"/resource",fname),"resource/"+fname)
	for dirname, subdirs, filenames in os.walk(ttscontentsuno+"/ttsshow"):
		for fname in filenames:
			ex = os.path.splitext(fname)
			if ex[1]==".html" or ex[1]==".js":
				zp.write(os.path.join(ttscontentsuno+"/ttsshow",fname),"ttsshow/"+fname)
	for dirname, subdirs, filenames in os.walk(ttscontentsuno+"/data"):
		for fname in filenames:
			ex = os.path.splitext(fname)
			if ex[1]==".json" or ex[1]==".png" or ex[1]==".jpg" or ex[1]==".bmp":
				zp.write(os.path.join(ttscontentsuno+"/data",fname),"data/"+fname)
	zp.close()
	print('<script>parent.donezip();</script>')
	exit()

print('<iframe src="" name="ifrm1" width="800" height="200" style="display:none"></iframe>')

print('<form name="fmtts" id="fmtts" action="tts.py" method="POST" target="ifrm1">')
print('<input type="hidden" name="numall" id="numall" value=""/>')
print('<input type="hidden" name="uno" value="'+str(uno)+'"/>')
print('<input type="hidden" name="fmid" id="fmid" value=""/>')
print('<input type="hidden" name="ttsno" id="ttsno" value=""/>')
print('<input type="hidden" name="ttstextsrc" id="ttstextsrc" value=""/>')
print('<input type="hidden" name="ttstext" id="ttstext" value=""/>')
print('<input type="hidden" name="usevoicenm" id="usevoicenm" value="false"/>')
selectboxstr='''
<table class='tblsrc'>
<tr><td>Language</td>
    <td><input type="hidden" name="voice" id="voice" value="en-US"/>
        <select name="lang" id="lang" onChange="setvoiceselect()">
            <option value="en-US">English(US)</option>
            <option value="ja-JP" selected>日本語</option>
        </select>
    </td>
    <td>Voice</td>
    <td>
        <select name="voiceen" id="voiceen" style="display:none">
            <option value="en-US-Standard-A">MAIL en-US-Standard-A</option>
            <option value="en-US-Standard-B">MAIL en-US-Standard-B</option>
            <option value="en-US-Standard-C">FEMAIL en-US-Standard-C</option>
            <option value="en-US-Standard-D">MAIL en-US-Standard-D</option>
            <option value="en-US-Standard-E">FEMAIL en-US-Standard-E</option>
            <option value="en-US-Standard-F">FEMAIL en-US-Standard-F</option>
            <option value="en-US-Standard-G">FEMAIL en-US-Standard-G</option>
            <option value="en-US-Standard-H">FEMAIL en-US-Standard-H</option>
            <option value="en-US-Standard-I">MAIL en-US-Standard-I</option>
            <option value="en-US-Standard-J">MAIL en-US-Standard-J</option>
			<option value="en-US-Wavenet-A">MAIL en-US-Wavenet-A</option>
			<option value="en-US-Wavenet-B">MAIL en-US-Wavenet-B</option>
			<option value="en-US-Wavenet-C">FEMAIL en-US-Wavenet-C</option>
			<option value="en-US-Wavenet-D">MAIL en-US-Wavenet-D</option>
			<option value="en-US-Wavenet-E">FEMAIL en-US-Wavenet-E</option>
			<option value="en-US-Wavenet-F">FEMAIL en-US-Wavenet-F</option>
			<option value="en-US-Wavenet-G">FEMAILen-US-Wavenet-G</option>
			<option value="en-US-Wavenet-H">FEMAIL en-US-Wavenet-H</option>
			<option value="en-US-Wavenet-I">MAIL en-US-Wavenet-I</option>
			<option value="en-US-Wavenet-J">MAIL en-US-Wavenet-J</option>

        </select>
        <select name="voicejp" id="voicejp" style="display:none">
            <option value="ja-JP-Standard-A">女性 ja-JP-Standard-A</option>
            <option value="ja-JP-Standard-B">女性 ja-JP-Standard-B</option>
            <option value="ja-JP-Standard-C">男性 ja-JP-Standard-C</option>
            <option value="ja-JP-Standard-D">男性 ja-JP-Standard-D</option>
            <option value="ja-JP-Wavenet-A">女性 ja-JP-Wavenet-A</option>
            <option value="ja-JP-Wavenet-B">女性 ja-JP-Wavenet-B</option>
            <option value="ja-JP-Wavenet-C">男性 ja-JP-Wavenet-C</option>
            <option value="ja-JP-Wavenet-D">男性 ja-JP-Wavenet-D</option>
        </select>
    </td>
</tr>
</table>
'''
print(selectboxstr)



ckboxstr = '''
Delimiter<br/>
<table class='tblsrc'>
<tr>
    <table  class='tblsrc'><tr>
    <td>半角</td>
    <td><input type="checkbox" name="ck1" id="ck1" value="1"/>ENTER &nbsp;</td>
    <td><input type="checkbox" name="ck2" id="ck2" value="1"/>. &nbsp;</td>
    <td><input type="checkbox" name="ck3" id="ck3" value="1"/>, &nbsp;</td>
    <td><input type="checkbox" name="ck4" id="ck4" value="1"/>? &nbsp;</td>
    <td><input type="checkbox" name="ck5" id="ck5" value="1"/>! &nbsp;</td>
    <td><input type="checkbox" name="ck6" id="ck6" value="1"/>; &nbsp;</td>
    <td><input type="checkbox" name="ck7" id="ck7" value="1"/>: &nbsp;</td>
    <td><input type="checkbox" name="ck8" id="ck8" value="1"/>' &nbsp;</td>
    <td><input type="checkbox" name="ck9" id="ck9" value="1"/>" &nbsp;</td>
    <td><input type="checkbox" name="ck10" id="ck10" value="1"/>( &nbsp;</td>
    <td><input type="checkbox" name="ck11" id="ck11" value="1"/>) &nbsp;</td>
    <td><input type="checkbox" name="ck12" id="ck12" value="1"/>TAB &nbsp;</td>
    <td><input type="checkbox" name="ck13" id="ck13" value="1"/>SPACE &nbsp;</td>
    <td><input type="checkbox" name="ck14" id="ck14" value="1"/>| (no display)&nbsp;</td>
    <td>^ (no display)&nbsp;</td>
    </tr>
    <tr>
    <td>全角</td>
    <td><input type="checkbox" name="ck21" id="ck21" value="1"/>。 &nbsp;</td>
    <td><input type="checkbox" name="ck22" id="ck22" value="1"/>、 &nbsp;</td>
    <td><input type="checkbox" name="ck23" id="ck23" value="1"/>？ &nbsp;</td>
    <td><input type="checkbox" name="ck24" id="ck24" value="1"/>！ &nbsp;</td>
    <td><input type="checkbox" name="ck25" id="ck25" value="1"/>「 &nbsp;</td>
    <td><input type="checkbox" name="ck26" id="ck26" value="1"/>」 &nbsp;</td>
    <td><input type="checkbox" name="ck27" id="ck27" value="1"/>『 &nbsp;</td>
    <td><input type="checkbox" name="ck28" id="ck28" value="1"/>』 &nbsp;</td>
    <td><input type="checkbox" name="ck29" id="ck29" value="1"/>（ &nbsp;</td>
    <td><input type="checkbox" name="ck30" id="ck30" value="1"/>） &nbsp;</td>
    <td><input type="checkbox" name="ck31" id="ck31" value="1"/>‘(begin)&nbsp;</td>
    <td><input type="checkbox" name="ck32" id="ck32" value="1"/>’(end)&nbsp;</td>
    <td><input type="checkbox" name="ck33" id="ck33" value="1"/>“(begin)&nbsp;</td>
    <td><input type="checkbox" name="ck34" id="ck34" value="1"/>”(end)&nbsp;</td>
    <td><input type="checkbox" name="ck35" id="ck35" value="1"/>スペース &nbsp;</td>
    </tr></table>
</tr>
</table>
'''


print(ckboxstr)
print('<input type="button" value="Upload and split with delimiter" onClick="splittext()">&nbsp;&nbsp;&nbsp;&nbsp;<input type="text" id="fixedlen" name="fixedlen" value="80" size="4" style="text-align:right"/><input type="button" value="Split text in area below with fixed length" onClick="splitchars()"/>&nbsp;&nbsp;&nbsp;&nbsp;<input type="button" value="Clear text in area below" onClick="cleartextarea();"/><br/>')

print('Maximum '+str(userdefine.limittextareacount)+'chars.&nbsp;&nbsp;')
if userdefine.removelimithours==0:
    print('Project will not be automatically deleted.<br/>')
else:
    print('Project will be automatically deleted '+str(userdefine.removelimithours)+' hours after created.<span id="lefthours" >'+str(lefthours)+'</span> hours left.<script>setTimeout(updatelefthours,3600*1000)</script><br/>')
print('<textarea name="txtcon" id="txtcon" maxlength="'+str(userdefine.limittextareacount)+'">'+html.escape(txtcon)+'</textarea><br/>')

print('</form><br/>')

print('<form name="fmexpt" action="tts.py" method="POST" target="ifrm1">')
print('<input type="hidden" name="uno" value="'+str(uno)+'"/>')
print('<input type="hidden" name="fmid" value="5"/>')
print('</form>')
print("<form name='jmpfm' action='tts.py' method='POST'><input type='hidden' name='fmid' value='50'/><input type='hidden' name='uno' value=''/></form>")

print("</body>")
print("</html>")